package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.objects.talents.CombatLuck;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class CombatLuckDialog extends GenericDialog {
	private static final long serialVersionUID = 6342766456695234664L;

	protected CombatLuck skill;

	protected JComboBox affectsCombo;

	protected JLabel affectsLbl;

	private JLabel rollLbl;

	public CombatLuckDialog(CombatLuck skill, boolean isNew, boolean isPower) {
		super(skill, isNew, isPower);
		this.skill = skill;
		init();
		if (pointsLbl != null) {
			pointsLbl.setVisible(false);
		}
		if (pointsTF != null) {
			pointsTF.setVisible(false);
		}
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 50;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(5, 5, 5, 5);
		gbc.gridx = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		gbc.gridy = 70;
		gbc.gridx = 2;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 1;
		panel.add(rollLbl, gbc);
		gbc.gridy = 80;
		gbc.gridx = 1;
		gbc.weightx = 1;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weighty = 0;
		gbc.weightx = 0;
		gbc.gridx = 0;
		gbc.gridy = 75;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		panel.add(affectsLbl, gbc);
		gbc.gridx = 1;
		gbc.gridwidth = 2;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(affectsCombo, gbc);
		gbc.gridx = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		affectsCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (affectsCombo.getSelectedIndex() == 0) {
					skill.setAffectPrimary(false);
					skill.setAffectTotal(true);
				} else if (affectsCombo.getSelectedIndex() == 1) {
					skill.setAffectPrimary(false);
					skill.setAffectTotal(false);
				} else {
					skill.setAffectPrimary(true);
					skill.setAffectTotal(true);
				}
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		rollLbl = new JLabel("Roll:");
		levelTF.setEnabled(true);
		levelsLbl.setEnabled(true);
		affectsLbl = new JLabel("Totaling Options:");
		ArrayList<String> vec = new ArrayList<String>();

		vec.add("Add to Secondary Value");
		vec.add("Do not add to Totals");
		vec.add("Add to Primary Value");

		affectsCombo = new JComboBox(vec.toArray());
		if (skill.getAffectPrimary()) {
			affectsCombo.setSelectedIndex(2);
		} else if (skill.getAffectTotal()) {
			affectsCombo.setSelectedIndex(0);
		} else {
			affectsCombo.setSelectedIndex(1);
		}

		updateValues();
	}

	@Override
	public void updateValues() {
		int pd = skill.getPdIncrease() * skill.getLevels()
				/ skill.getPdIncreaseLevels();
		int ed = skill.getEdIncrease() * skill.getLevels()
				/ skill.getEdIncreaseLevels();
		rollLbl.setText(pd + " PD/" + ed + " ED");
		super.updateValues();
	}
}